/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.data.DETags;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.security.InvalidParameterException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;

public class DEConfig {
    public static final Common COMMON;
    protected static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        protected Common(ForgeConfigSpec.Builder builder) {
            Common.StructureBiomes(DEStructures.CASTLE).whitelist(new TagKey[]{Tags.Biomes.IS_COLD_OVERWORLD, Tags.Biomes.IS_SNOWY}).blacklist(new TagKey[]{Tags.Biomes.IS_WATER, Tags.Biomes.IS_MOUNTAIN, DETags.Biomes.IS_SHORE}).popBiomes().build(builder);
            Common.OverworldExceptStructure(builder, DEStructures.DEEP_CRYPT, new TagKey[0]);
            Common.TagsStructure(builder, DEStructures.DESERT_TEMPLE, BiomeTags.f_207614_);
            Common.TagsStructure(builder, DEStructures.DESERT_TOMB, BiomeTags.f_207614_);
            Common.TagsStructure(builder, DEStructures.DRUID_CIRCLE, Tags.Biomes.IS_PLAINS);
            Common.OverworldExceptStructure(builder, DEStructures.DUNGEON_VARIANT, new TagKey[0]);
            Common.TagsStructure(builder, DEStructures.ELDERS_TEMPLE, BiomeTags.f_207602_);
            Common.ShipStructure(builder, DEStructures.FISHING_SHIP);
            Common.TagsStructure(builder, DEStructures.FLYING_DUTCHMAN, Tags.Biomes.IS_WATER);
            Common.StructureBiomes(DEStructures.HAY_STORAGE).whitelist(new TagKey[]{BiomeTags.f_215816_}).blacklist(new TagKey[]{DETags.Biomes.IS_BAD_FOR_STRUCTURE}).popBiomes().build(builder);
            Common.StructureBiomes(DEStructures.ICE_PIT).whitelist(new TagKey[]{Tags.Biomes.IS_SNOWY}).blacklist(new TagKey[]{Tags.Biomes.IS_WATER, Tags.Biomes.IS_MOUNTAIN, DETags.Biomes.IS_SHORE}).popBiomes().build(builder);
            Common.TagsStructure(builder, DEStructures.JUNGLE_MONUMENT, BiomeTags.f_207616_);
            Common.StructureBiomes(DEStructures.LARGE_DUNGEON).whitelist(new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207609_}).blacklist(new TagKey[]{DETags.Biomes.IS_BAD_FOR_STRUCTURE, Tags.Biomes.IS_MOUNTAIN, Tags.Biomes.IS_WATER}).popBiomes().build(builder);
            Common.TagsStructure(builder, DEStructures.MINERS_HOUSE, BiomeTags.f_207607_);
            Common.BiomesStructure(builder, DEStructures.MONSTER_MAZE, Biomes.f_48151_);
            Common.BiomesStructure(builder, DEStructures.MUSHROOM_HOUSE, Biomes.f_48215_);
            Common.TagsStructure(builder, DEStructures.PILLAGER_CAMP, BiomeTags.f_207622_);
            Common.ShipStructure(builder, DEStructures.PIRATE_SHIP);
            Common.StructureBiomes(DEStructures.RUINED_BUILDING).whitelist(new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207609_}).blacklist(new TagKey[]{DETags.Biomes.IS_BAD_FOR_STRUCTURE, Tags.Biomes.IS_MOUNTAIN, Tags.Biomes.IS_WATER}).popBiomes().build(builder);
            Common.StructureBiomes(DEStructures.STABLES).whitelist(new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_}).blacklist(new TagKey[]{DETags.Biomes.IS_BAD_FOR_STRUCTURE, Tags.Biomes.IS_MOUNTAIN, Tags.Biomes.IS_WATER}).blacklist(new ResourceKey[]{Biomes.f_48151_}).popBiomes().build(builder);
            Common.TagsStructure(builder, DEStructures.SUNKEN_SHRINE, BiomeTags.f_207603_);
            Common.TagsStructure(builder, DEStructures.TALL_WITCH_HUT, BiomeTags.f_207589_);
            Common.OverworldExceptStructure(builder, DEStructures.TOWER_OF_THE_UNDEAD, Tags.Biomes.IS_SANDY, Tags.Biomes.IS_WATER, BiomeTags.f_207610_, DETags.Biomes.IS_BAD_FOR_STRUCTURE, BiomeTags.f_207607_);
            Common.TagsStructure(builder, DEStructures.TREE_HOUSE, BiomeTags.f_207610_);
            Common.TagsNoWaterStructure(builder, DEStructures.WATCH_TOWER, Tags.Biomes.IS_COLD_OVERWORLD);
            Common.TagsStructure(builder, DEStructures.WITCH_TOWER, BiomeTags.f_207609_);
        }

        @SafeVarargs
        private static void TagsStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, TagKey<Biome> ... tagKeys) {
            Common.StructureBiomes(structure).whitelist(tagKeys).popBiomes().build(builder);
        }

        @SafeVarargs
        private static void TagsNoWaterStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, TagKey<Biome> ... tagKeys) {
            Common.StructureBiomes(structure).whitelist(tagKeys).blacklist(new TagKey[]{Tags.Biomes.IS_WATER}).popBiomes().build(builder);
        }

        @SafeVarargs
        private static void OverworldExceptStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, TagKey<Biome> ... tagKeys) {
            Common.StructureBiomes(structure).whitelist(new TagKey[]{BiomeTags.f_215817_}).blacklist(tagKeys).popBiomes().build(builder);
        }

        private static void ShipStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure) {
            Common.OceanExceptStructure(builder, structure, Tags.Biomes.IS_SNOWY);
        }

        @SafeVarargs
        private static void OceanExceptStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, TagKey<Biome> ... tagKeys) {
            Common.StructureBiomes(structure).whitelist(new TagKey[]{BiomeTags.f_207603_}).blacklist(tagKeys).popBiomes().build(builder);
        }

        @SafeVarargs
        private static void BiomesStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, ResourceKey<Biome> ... biomes) {
            Common.StructureBiomes(structure).whitelist(biomes).popBiomes().build(builder);
        }

        private static StructureConfig.Builder.BiomeConfigBuilder StructureBiomes(StructureRegistrar<? extends Structure> structure) {
            if (structure.getStructure() == null) {
                throw new InvalidParameterException("Need to be a single structure");
            }
            return StructureConfig.builder((Registrar)structure.getStructure()).pushBiomes();
        }
    }
}

